#include "SDL.h"
#include "SDL_image.h"
#include <iostream>
#include <string>
#include <cmath>

using namespace std;

const int SLEEP_TIME = 3;
const int DEFAULT_WID = 800;
const int DEFAULT_HEI = 600;
const int DEFAULT_DEPTH = 32;

// exit function as before
void exitFunc(void) {
    SDL_Quit();
}

// a routine to select a good screen for the application.
SDL_Surface * setUpScreen(void) {
    SDL_Surface * tmp;
    int wid, hei;
    int max;
    int bpp;

    // describe the screen you want.
    int flag = 0;

    SDL_Rect ** modes;

    modes = SDL_ListModes(NULL,flag);

    if (modes == NULL) {
       // if there is no video bail.
       tmp =  NULL;
    } else  if (modes ==(SDL_Rect **)  -1) {
       // if I have infinate choices use the default
       tmp = SDL_SetVideoMode(DEFAULT_WID, DEFAULT_HEI, DEFAULT_DEPTH, flag);
    } else {
       // step through the available screens
       int i;

       // grab the most pixels I can;
       i = 0;
       max = modes[i]->w*modes[i]->h;
       wid = modes[i]->w;
       hei = modes[i]->h;
       for(i=1;modes[i];i++) {
          if (modes[i]->w * modes[i]->h > max) {
              max = modes[i]->w*modes[i]->h;
              wid = modes[i]->w;
              hei = modes[i]->h;
	  }
       }

       //see the pixel depth that the screen can be
       bpp= SDL_VideoModeOK(wid,hei,DEFAULT_DEPTH,flag);
       if (bpp == 0) {
          // oops, can't do it
          tmp = NULL;
       } else {
          // yes we can, so grab it.
          tmp = SDL_SetVideoMode(wid,hei,bpp,flag);
       }
    }
    return tmp;
}

void hexCorner(int a, int b, int & x, int & y, int r1, int r2) {
          // this is the center of the hex
          x = ((a/2)*3+1)*r1;
          y = b*r2;

	  if (a%2 == 0) {
	      x -= int(1.5*r1);
	  }

	  x -= r1;
	  y -= r2;
}

int main() {
    if( SDL_Init(SDL_INIT_VIDEO ) != 0 ){
	cout << "Unable to Initialize SDL " << SDL_GetError() << endl;
        return -1;	
    }
    atexit(exitFunc);

    // this will be the size of the new screen, draw on it.
    SDL_Surface * mainScreen;

    mainScreen = setUpScreen();

    // make sure it is valid after we grab it.
    if (mainScreen == NULL) {
	cout << "Unable open an SDL screen " << SDL_GetError() << endl;
        return -1;	
    } 


    // grab a hex surface to draw.  In this case, use SDL_Image to 
    // load a gif file.
    string filename = "gifs/hexGreen.gif";
    SDL_Surface * thingToDraw;

    // try to load a BMP
    thingToDraw = IMG_Load(filename.c_str());
    if(thingToDraw == NULL) {
         cout << "Unable to load " << filename << " " << IMG_GetError() << endl;
	 return(-1);
    }

    // Mark White as a color not to be drawn.
    Uint32 tmpColor;
    tmpColor = SDL_MapRGB(thingToDraw->format, 255,255,255);

    SDL_SetColorKey( thingToDraw, SDL_SRCCOLORKEY | SDL_RLEACCEL , tmpColor);

    SDL_Rect  src, dest;

    int i,j;
    int startPos;

    src.w = thingToDraw->w;
    src.h = thingToDraw->h;
    src.x = 0;
    src.y = 0;

    int r1 = thingToDraw->w/2;
    int r2 = thingToDraw->h/2;

    for(i=0; i <= DEFAULT_HEI/r2 + 1;i++) {

       // odd rows start at 1 even at two
       if (i%2==1) {
          startPos = 1;
       } else {
          startPos = 0;
       }

       for(j=startPos; j <= DEFAULT_WID/(r1*1.5) + 1;j+=2) {
          int x,y;
          hexCorner(j,i,x, y, r1, r2);
	  dest.x = x;
	  dest.y = y;
          SDL_BlitSurface(thingToDraw, &src, mainScreen, & dest);
       }
    }

    SDL_UpdateRect(mainScreen,0,0,0,0);
    sleep(10);

    SDL_FreeSurface(thingToDraw);
    return 0;
}
