#include "SDL.h"
#include "SDL_image.h"
#include <iostream>
#include <string>

using namespace std;

const int SLEEP_TIME = 3;
const int DEFAULT_WID = 800;
const int DEFAULT_HEI = 600;
const int DEFAULT_DEPTH = 32;

// exit function as before
void exitFunc(void) {
    SDL_Quit();
}

// a routine to select a good screen for the application.
SDL_Surface * setUpScreen(void) {
    SDL_Surface * tmp;
    int wid, hei;
    int max;
    int bpp;

    // describe the screen you want.
    int flag = 0;

    SDL_Rect ** modes;

    modes = SDL_ListModes(NULL,flag);

    if (modes == NULL) {
       // if there is no video bail.
       tmp =  NULL;
    } else  if (modes ==(SDL_Rect **)  -1) {
       // if I have infinate choices use the default
       tmp = SDL_SetVideoMode(DEFAULT_WID, DEFAULT_HEI, DEFAULT_DEPTH, flag);
    } else {
       // step through the available screens
       int i;

       // grab the most pixels I can;
       i = 0;
       max = modes[i]->w*modes[i]->h;
       wid = modes[i]->w;
       hei = modes[i]->h;
       for(i=1;modes[i];i++) {
          if (modes[i]->w * modes[i]->h > max) {
              max = modes[i]->w*modes[i]->h;
              wid = modes[i]->w;
              hei = modes[i]->h;
	  }
       }

       //see the pixel depth that the screen can be
       bpp= SDL_VideoModeOK(wid,hei,DEFAULT_DEPTH,flag);
       if (bpp == 0) {
          // oops, can't do it
          tmp = NULL;
       } else {
          // yes we can, so grab it.
          tmp = SDL_SetVideoMode(wid,hei,bpp,flag);
       }
    }
    return tmp;
}

int main() {
    if( SDL_Init(SDL_INIT_VIDEO ) != 0 ){
	cout << "Unable to Initialize SDL " << SDL_GetError() << endl;
        return -1;	
    }
    atexit(exitFunc);

    // this will be the size of the new screen, draw on it.
    SDL_Surface * mainScreen;

    mainScreen = setUpScreen();

    // make sure it is valid after we grab it.
    if (mainScreen == NULL) {
	cout << "Unable open an SDL screen " << SDL_GetError() << endl;
        return -1;	
    } 


    // grab a hex surface to draw.  In this case, use SDL_Image to 
    // load a gif file.
    string filename = "gifs/hexRoad6.gif";
    SDL_Surface * thingToDraw;

    // try to load a BMP
    thingToDraw = IMG_Load(filename.c_str());
    if(thingToDraw == NULL) {
         cout << "Unable to load " << filename << " " << IMG_GetError() << endl;
	 return(-1);
    }

    // Mark White as a color not to be drawn.
    Uint32 tmpColor;
    tmpColor = SDL_MapRGB(thingToDraw->format, 255,255,255);

    SDL_SetColorKey( thingToDraw, SDL_SRCCOLORKEY | SDL_RLEACCEL , tmpColor);

    SDL_Rect  src, dest;

    // what part of the image do we wish to draw
    src.x = 0;
    src.y = 0;
    src.w = thingToDraw->w;
    src.h = thingToDraw->h;

    // where do we wish to draw it?
    dest.x = (mainScreen->w - thingToDraw->w)/2;
    dest.y = (mainScreen->h - thingToDraw->h)/2;

    // display it.
    SDL_BlitSurface(thingToDraw, &src, mainScreen, & dest);

    // tell SDL to update the screen
    SDL_UpdateRect(mainScreen,0,0,0,0);
    sleep(3);

    // properly dispose of the surface
    SDL_FreeSurface(thingToDraw);
    return 0;
}
